/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.entity.PhotographEntity;
import io.github.mortuusars.exposure.gui.ClientGUI;
import io.github.mortuusars.exposure.gui.component.PhotographTooltip;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographItem
extends Item {
    public PhotographItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public Either<String, ResourceLocation> getIdOrTexture(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return null;
        }
        String id = stack.m_41783_().m_128461_("Id");
        if (!id.isEmpty()) {
            return Either.left((Object)id);
        }
        String resource = stack.m_41783_().m_128461_("Texture");
        if (!resource.isEmpty()) {
            return Either.right((Object)new ResourceLocation(resource));
        }
        return null;
    }

    public void setId(ItemStack stack, @NotNull String id) {
        Preconditions.checkState((!StringUtil.m_14408_((String)id) ? 1 : 0) != 0, (Object)"'id' cannot be null or empty.");
        stack.m_41784_().m_128359_("Id", id);
    }

    public void setTexture(ItemStack stack, @NotNull ResourceLocation resourceLocation) {
        stack.m_41784_().m_128359_("Texture", resourceLocation.toString());
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        return this.getIdOrTexture(stack) != null ? Optional.of(new PhotographTooltip(stack)) : Optional.empty();
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        if (stack.m_41783_() != null) {
            Either<String, ResourceLocation> idOrTexture;
            String photographerName;
            int generation = stack.m_41783_().m_128451_("generation");
            if (generation > 0) {
                tooltipComponents.add((Component)Component.m_237115_((String)("item.exposure.photograph.generation." + generation)).m_130940_(ChatFormatting.GRAY));
            }
            if (!(photographerName = stack.m_41783_().m_128461_("Photographer")).isEmpty() && ((Boolean)Config.Client.PHOTOGRAPH_SHOW_PHOTOGRAPHER_IN_TOOLTIP.get()).booleanValue()) {
                tooltipComponents.add((Component)Component.m_237110_((String)"item.exposure.photograph.photographer_tooltip", (Object[])new Object[]{Component.m_237113_((String)photographerName).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
            }
            if (generation < 2 && !PlatformHelper.isModLoaded("jei") && ((Boolean)Config.Client.RECIPE_TOOLTIPS_WITHOUT_JEI.get()).booleanValue()) {
                ClientGUI.addPhotographCopyingTooltip(stack, level, tooltipComponents, isAdvanced);
            }
            if (isAdvanced.m_7050_() && (idOrTexture = this.getIdOrTexture(stack)) != null) {
                String text = (String)idOrTexture.map(id -> "Exposure Id: " + id, texture -> "Texture: " + texture);
                tooltipComponents.add((Component)Component.m_237113_((String)text).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos resultPos = clickedPos.m_121945_(direction);
        Player player = context.m_43723_();
        ItemStack itemStack = context.m_43722_();
        if (player == null || player.m_9236_().m_151570_(resultPos) || !player.m_36204_(resultPos, direction, itemStack)) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        PhotographEntity photographEntity = new PhotographEntity(level, resultPos, direction, itemStack.m_41777_());
        if (photographEntity.m_7088_()) {
            if (!level.f_46443_) {
                photographEntity.m_7084_();
                level.m_220400_((Entity)player, GameEvent.f_157810_, photographEntity.m_20182_());
                level.m_7967_((Entity)photographEntity);
            }
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (this.getIdOrTexture(itemInHand) == null) {
            LogUtils.getLogger().warn("No Id or Texture is defined. - " + itemInHand);
        }
        if (level.f_46443_) {
            ClientGUI.openPhotographScreen(List.of(new ItemAndStack(itemInHand)));
            player.m_5496_(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, 1.1f);
        }
        return InteractionResultHolder.m_19090_((Object)itemInHand);
    }

    public boolean m_142305_(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (other.m_41720_() instanceof PhotographItem) {
            StackedPhotographsItem stackedPhotographsItem = Exposure.Items.STACKED_PHOTOGRAPHS.get();
            ItemStack stackedPhotographsStack = new ItemStack((ItemLike)stackedPhotographsItem);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, stack);
            stackedPhotographsItem.addPhotographOnTop(stackedPhotographsStack, other);
            slot.m_5852_(ItemStack.f_41583_);
            access.m_142104_(stackedPhotographsStack);
            StackedPhotographsItem.playAddSoundClientside(player);
            return true;
        }
        return false;
    }
}

